//@author: colorsound


// -----------------------------------------------------------------------------
// PARAMETERS:
// -----------------------------------------------------------------------------

//transforms
float4x4 tW: WORLD;        //the models world matrix
float4x4 tV: VIEW;         //view matrix as set via Renderer 
float4x4 tWV: WORLDVIEW;
float4x4 tVP: VIEWROJECTION;
float4x4 tWVP: WORLDVIEWPROJECTION;
float4x4 tP: PROJECTION;   //projection matrix as set via Renderer 

//Functions
#include "PhongDirectional.fxh"
#include "Transform.fxh"

//Texture
Texture2D texture2d <string uiname="Texture"; >; 

SamplerState g_samLinear
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};

//Pins 
bool TexCoordsToModelCoords = 1; 

float4x4 tTex <bool uvspace=true; string uiname="Texture Transform";>;
float4x4 tColor <string uiname="Color Transform";>;

//Buffers
int IntanceStartIndex = 0;

StructuredBuffer<float4x4> sbworld; // Add this variable for the transform buffer
int worldcnt;//add the count of your transform buffer

StructuredBuffer<float4> sbcolor; // Add this variable for the color buffer
int colorcnt;//add the count of your color buffer

struct Oscillator
{
	
	
float CurrentPos;
float GoalPos;
float PreviousPos;	
float CurrentVel;
float PreviousVel;	
float DirValue;
float ProcessValue;

};

StructuredBuffer<Oscillator> OscillatorIn;

int FrameDiffVcnt;

StructuredBuffer<float2> uv;
int uvcnt;

//struct to pass from VS to PS
struct vs2ps
{
    float4 PosWVP: SV_POSITION;
    float4 TexCd : TEXCOORD0;
    float3 LightDirV: TEXCOORD1;
    float3 NormV: TEXCOORD2;
    float3 ViewDirV: TEXCOORD3;
	float4 color: COLOR0;
	
};

// -----------------------------------------------------------------------------
// VERTEXSHADERS
// -----------------------------------------------------------------------------
//uint iv : SV_VertexID;
vs2ps VS(
    float4 PosO: POSITION,
    float3 NormO: NORMAL,
    float4 TexCd : TEXCOORD0,
    uint ii : SV_InstanceID)
{
    //inititalize all fields of output struct with 0
    vs2ps Out = (vs2ps)0;
	
	//For Tranform Function
    float3 Translate ={0,0,0};
	float3 Scale ={1,1,1};
	float3 Rotation = {0,0,0};
	float3 TranslateOffset = {0,0,0};
	
	
	
	
////// The Oscillator Testing	

	float processValue =  OscillatorIn[(ii + IntanceStartIndex)% FrameDiffVcnt ].ProcessValue ;
	Scale.z =processValue; //Apply this value to Z scale to visualize
//////	
//Transforms
	float4 Trans_0 = Transform3D(PosO,Translate,Scale,Rotation,TranslateOffset);
    //World with Index
    float4x4 w = mul(tW,sbworld[(ii + IntanceStartIndex) % worldcnt]);
	
	//TexCoordsToModelCoords Get Texcoords Buffer and apply to matrix 
	//then multiply by Texcd
	float2 tc = uv[ii + IntanceStartIndex % uvcnt];
	matrix TexCoords= {0,0,0,0,  0,0,0,0,  0,0,0,0,tc.x,tc.y,0,1} ;
	
	
	//Multiply position to the World Indexed Pos to Transform Matrix 
    float4 PosV = mul(Trans_0,w);

    float4x4 wv = mul(w,tV);
	float4x4 wvp = mul(w,tVP);

	
    //inverse light direction in view space
    Out.LightDirV = normalize(-mul(lDir,wv));
    
    //normal in view space
    Out.NormV = normalize(mul(NormO,wv));
    
    //position (projected)
	
    Out.PosWVP  = mul(PosV,tWVP);
	Out.TexCd = mul(TexCd,tTex );
	
	//Enable TexCoordsToModelCoords
	if (TexCoordsToModelCoords)
    Out.TexCd = mul(TexCd,TexCoords);
	
	
    Out.ViewDirV = -normalize(mul(PosV,tV));
	Out.color =  sbcolor[ii % colorcnt];
	//Send values from CS Buffer to PS

	
    return Out;
}

// -----------------------------------------------------------------------------
// PIXELSHADERS:
// -----------------------------------------------------------------------------

float Alpha <float uimin=0.0; float uimax=1.0;> = 1;

float4 PS(vs2ps In): SV_Target
{
    float4 col = texture2d.Sample(g_samLinear,In.TexCd.xy);
    col.rgb *= PhongDirectional(In.NormV, In.ViewDirV, In.LightDirV);
	col.rgb *= mul (In.color,tColor); // Get the color and multiply by Color Transform

	
	
    col.a *= Alpha;
    

    return col;
}


// -----------------------------------------------------------------------------
// TECHNIQUES:
// -----------------------------------------------------------------------------
technique10 TOscillatorVisualize
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}
